#ifndef __CAPTURE_H
#define __CAPTURE_H



/*
	Input Capture Module
	
	capture.h
	
	by Mauro Grassi, September 2010.
	
*/
#define INTERRUPT_PRIORITY_CAPTURE	1

#define NO_FREQUENCY_MODE			0x00	/* used for counting */
#define LOW_FREQUENCY_MODE			0x01
#define MEDIUM_FREQUENCY_MODE		0x02
#define HIGH_FREQUENCY_MODE			0x03
 
#define ALLOW_FREQUENCY_SCALING		0x80
#define COUNT_RISING_EDGES			0x40	/* otherwise low */

#define CAPTURE_OVERFLOW_LIMIT_LOW			32.0
#define CAPTURE_OVERFLOW_LIMIT_MEDIUM		1000.0
#define CAPTURE_OVERFLOW_LIMIT_HIGH			(1000.0/16.0)

#define INITIAL_CAPTURE_STATE		0
#define WAIT_CAPTURE_STATE			1
#define FINISH_CAPTURE_STATE		2
#define IDLE_CAPTURE_STATE			3

#define NUM_CAPTURE_OBJECTS			6
#define TOTAL_PHYSICAL_CHANNELS		7
#define CAPTURE_LOGICAL_CHANNELS	6

typedef struct
{
	float 			frequencyOrCounter;		/* measured frequency or counter */
	float			scaledTimerFrequency;	/* the scaled timer frequency incorporating the Timer Frequency and the prescale and postscale values */
	unsigned char 	mode;					/* mode of operation, changes the frequency range */
	unsigned char	inputNumber;			/* the input number */
	unsigned int	captureT[2];			/* used internally */
	unsigned int	captureTimer[2];
	char 			captureIndex;			/* used internally */
	unsigned char	captureState;			/* state of the FSM (Finite State Machine) */
	unsigned char	ccpcon;					/* CCPxCON value */
	unsigned char 	status;
} CAPTURE_OBJECT;

unsigned char 					capture_Task(CAPTURE_OBJECT* captureObject);
void 							doCaptureInterrupt(void);
void 							initCapture(void);
int 							openCaptureObject(unsigned char physicalChannel, unsigned char mode);
void 							capture_FullTask(void);
void 							showCaptureObjects(void);
void 							showAllCaptureObjects(void);
float 							readCaptureObjectChannel(unsigned char physicalChannel, unsigned char* ready);
int 							closeCaptureObject(unsigned char physicalChannel);
int 							deleteCaptureObject(unsigned char num);
extern volatile unsigned char  	captureObjectInputNumber[TOTAL_PHYSICAL_CHANNELS];		/* holds the mapping from physical channels back to logical channels, ie. capture objects */
extern volatile CAPTURE_OBJECT	captureObjectNumber[NUM_CAPTURE_OBJECTS];
extern volatile unsigned char  	totalCaptureObjects;
int 							upScaleCaptureObject(CAPTURE_OBJECT* captureObject);
int								downScaleCaptureObject(CAPTURE_OBJECT* captureObject);
void 							powerCapture(unsigned char on);
int 							internalCloseCaptureObject(unsigned char physicalChannel);
void 							clearCapture(void);
void 							reopenCloseCaptureObject(unsigned char on);
void							calculateTimerUses(void);

#if(IS_PC_HOST)

#else

extern const rom unsigned char captureChannels[CAPTURE_LOGICAL_CHANNELS];
extern volatile unsigned char  totalCaptureObjects;
extern volatile unsigned char  timer3OverFlow;
extern volatile unsigned char  timer3Refs;
extern volatile unsigned char  timer5OverFlow;
extern volatile unsigned char  timer5Refs;

#endif

#endif
